#!/bin/bash
set -e

block_device=""
for vendor_path in /sys/class/block/sd?/device/vendor; do
  echo "checking $vendor_path .." >&2
  if [ -f "$vendor_path" ]; then
    res=$(grep JMicron $vendor_path)
    if [ -n $res ]; then
      echo "Found 'JMicron' in $vendor_path" >&2

      model_path=$(dirname $vendor_path)/model
      echo model_path $model_path >&2
      res=$(grep Generic $model_path)
      if [ -n $res ]; then
        block_device=$(basename $(dirname $(dirname $vendor_path)))
        echo "Found 'Generic' in $model_path: dev $block_device" >&2
        break
      fi
    fi
  fi
done

dev=/dev/$block_device
echo "checking if $dev is a block dev.." >&2
if [ -b $dev ]; then
  blkid -o value $dev|head -1|tr -d '\n'
  exit 0
fi

exit 1
